-- /* CREATE TABLE tartikel.beleg_k__artchange (

DROP TABLE IF EXISTS tartikel.beleg_k__artchange CASCADE;

--

-- Kopf

--
CREATE TABLE tartikel.beleg_k__artchange (
  kartc_x_artcv_key_kategorie            VARCHAR(5),-- REFERENCES tartikel.beleg_x__artchange__vorgaben(x_artcv_key) ON UPDATE CASCADE, -- Kategorie
  -- bdac_zuotyp                INTEGER,            --Zurordnung/Typ
  kartc_antrag_db_usename                VARCHAR(10) REFERENCES llv(ll_db_usename) ON UPDATE CASCADE DEFAULT tsystem.current_user_ll_db_usename(), --Antragsteller
  kartc_antrag_ks_abt                    VARCHAR(9) REFERENCES ksv ON UPDATE CASCADE, --KS des Antragstellers

  kartc_x_artcv_key_abt                  VARCHAR(5),-- REFERENCES tartikel.beleg_x__artchange__vorgaben(x_artcv_key) ON UPDATE CASCADE, --Abteilung
  kartc_x_artcv_key_prio                 VARCHAR(5),-- REFERENCES tartikel.beleg_x__artchange__vorgaben(x_artcv_key) ON UPDATE CASCADE, --Priorität

  kartc_serie                            VARCHAR(25),          --Serie
  kartc_aknr_bg                          VARCHAR(40) REFERENCES art ON UPDATE CASCADE, --Baugruppe
  kartc_txt_beschreibung                 TEXT,                 --Beschreibung der Änderung
  kartc_txt_grund                        TEXT,                 --Änderungsgrund

  kartc_x_artcv_key_fb                   VARCHAR(5),-- REFERENCES tartikel.beleg_x__artchange__vorgaben(x_artcv_key) ON UPDATE CASCADE, --Fachbereich
  kartc_x_artcv_key_stat                 VARCHAR(5),-- REFERENCES tartikel.beleg_x__artchange__vorgaben(x_artcv_key) ON UPDATE CASCADE, --Status

  kartc_datum_gueltigab                  DATE,                 --gültig ab (frühester Termin)
  kartc_sernr_ab                         VARCHAR(25),          --ab Seriennummer
  kartc_txt_ergebnis                     TEXT,                 --Ergebnisse der Wirksamkeitsprüfung
  kartc_txt_abhaengig                    TEXT,                 --Bemerkung zu Abhängigkeiten

  kartc_abschluss_datum                  DATE,                        --Da wurde Beleg abgeschlossen, bezahlt, verbucht oder so
  kartc_abschluss_db_usename             VARCHAR(10) REFERENCES llv(ll_db_usename) ON UPDATE CASCADE DEFAULT tsystem.current_user_ll_db_usename(), -- Änderung abgeschlossen durch
  --
  --Register Kosten
  kartc_kostg_entwicklung                NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Entwicklungskosten
  kartc_kostg_umarbeitung                NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Kosten der Umarbeit
  kartc_kostg_service                    NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Servicekosten
  kartc_kostg_verschrottung              NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Kosten der Verschrottung
  kartc_kostg_preis_produktaenderung     NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Veränderung der Produktkosten ? Prospekte und sonstiges?
  kartc_kostg_tot                        NUMERIC(12,4) NOT NULL DEFAULT 0, -- geplante Gesamtkosten des Änderungsvorgangs = Entiwklung + Verschorttung
  kartc_txt_koordinator                  TEXT,                 -- Kommentare Koordinator
  kartc_kost_quelleabsch                 VARCHAR(50)           -- Quelle der Kostenabschätzung
 ) INHERITS (TSystem_Wawi.beleg_k__preise, TSystem_Wawi.beleg_x__allgfields_varchar);

-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_k__trigger__all__create('tartikel','beleg_k__artchange');
 SELECT  TSystem_Wawi.beleg_k__constraints__all__create('tartikel','beleg_k__artchange');
-- Defaults
 ALTER TABLE tartikel.beleg_k__artchange ALTER COLUMN k_ad_krz SET DEFAULT '#';

------------------------------------------------
CREATE OR REPLACE FUNCTION tartikel.beleg_k__artchange__kartc_kostg_tot__get(rec tartikel.beleg_k__artchange) RETURNS NUMERIC AS $$
BEGIN
  --Summe der Vorkalkulationspreise
  RETURN (SELECT rec.k_wert_netto +
                 -- und geplanter Kosten
                 rec.kartc_kostg_entwicklung +
                 rec.kartc_kostg_umarbeitung +
                 rec.kartc_kostg_service +
                 rec.kartc_kostg_preis_produktaenderung +
                 rec.kartc_kostg_verschrottung);
END $$ LANGUAGE plpgsql STABLE;

CREATE OR REPLACE FUNCTION tartikel.beleg_k__artchange__b_500_iu__wert__tot__calculated() RETURNS TRIGGER AS $$
BEGIN
  new.kartc_kostg_tot := tartikel.beleg_k__artchange__kartc_kostg_tot__get(new);
  RETURN new;
END $$ LANGUAGE plpgsql STABLE;

 CREATE TRIGGER b_500_iu__artchange__wert__tot__calculated
   BEFORE INSERT OR UPDATE OF
     kartc_kostg_entwicklung, kartc_kostg_umarbeitung, kartc_kostg_service, kartc_kostg_preis_produktaenderung, kartc_kostg_verschrottung
   ON tartikel.beleg_k__artchange
   FOR EACH ROW
   EXECUTE PROCEDURE tartikel.beleg_k__artchange__b_500_iu__wert__tot__calculated();
------------------------------------------------

CREATE TRIGGER beleg_k__artchange_a_i__create_autoparams
  AFTER INSERT
  ON tartikel.beleg_k__artchange
  FOR EACH ROW
  EXECUTE PROCEDURE trecnoparam.createautoparams();
------------------------------------------------

 CREATE TRIGGER beleg_k__artchange_delete_abk_project_structure
  AFTER DELETE
  ON tartikel.beleg_k__artchange
  FOR EACH ROW
  EXECUTE PROCEDURE public.table_delete_abkstru();
--

-- Position

--
CREATE TABLE tartikel.beleg_p__artchange (
  partc_aknr_neu                        VARCHAR(40) REFERENCES art ON UPDATE CASCADE, --Artikelnummer (neu)
  partc_strid_alt                       INTEGER REFERENCES stvrevision ON UPDATE CASCADE ON DELETE CASCADE, -- Revision (alt)
  partc_strid_neu                       INTEGER REFERENCES stvrevision ON UPDATE CASCADE ON DELETE CASCADE, -- Revision (neu)
  partc_op_ix_alt                       INTEGER REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE, -- ASK (alt)
  partc_op_ix_neu                       INTEGER REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE, -- ASK (neu)
  partc_parent_k_id                     INTEGER -- Übergeordneter Änderungsvorgang

 ) INHERITS (TSystem_Wawi.beleg_p__art);
-- Constraints und Trigger
 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('tartikel','beleg_p__artchange', 'tartikel','beleg_k__artchange');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('tartikel','beleg_p__artchange');

----Preis aus Vorkalkulation für Änderungsverwaltung---------------
CREATE TABLE tartikel.beleg_p__artchange__vorkalk(
  -- p_id          bvk_id        SERIAL PRIMARY KEY,
  -- p_k_id        bvk_beld_id   INTEGER, -- REFERENCES bdac ON UPDATE CASCADE ON DELETE CASCADE,
  -- p_pos         bvk_pos       INTEGER NOT NULL,            -- Position
  -- p_menge       bvk_anz       NUMERIC NOT NULL DEFAULT 0,  -- Anzahl
  partcvk_mebez     VARCHAR(20)                  --Mengeneinheit für Menge, zB Stunde, Stück, kg etc
  -- p_preis       bvk_preis     NUMERIC NOT NULL DEFAULT 0,  -- Positionspreis
  -- p_ak_bez      bvk_bez       VARCHAR(40),                 -- Bezeichnung
  -- bvk_indok     BOOL NOT NULL DEFAULT FALSE, --soll auf Dokument dargestellt werden
  -- p_txt          bvk_txt       TEXT,                        --Beschreibungstext/Erläuterung
  -- bvk_txt_rtf   TEXT
 )INHERITS (TSystem_Wawi.beleg_p, TSystem_Wawi.beleg_p__preise_base);

 SELECT  TSystem_Wawi.beleg_p__constraints__all__create('tartikel','beleg_p__artchange__vorkalk', 'tartikel','beleg_k__artchange');
 SELECT  TSystem_Wawi.beleg_p__trigger__all__create('tartikel','beleg_p__artchange__vorkalk');

-- TODO: Keywordsearch, auditlog
